﻿/* Skript zur Demonstration von Inner Joins.
 * Als Benutzer HR ausführen
 */
 
-- einfacher Join zwischen EMPLOYEES und JOBS
select e.last_name, e.job_id, j.job_id, j.job_title
  from employees e join jobs j
    on e.job_id = j.job_id;
	
-- einfacher Join zwischen EMPLOYEES, JOBS und DEPARTMENTS
select e.last_name, j.job_title, d.department_name
  from employees e
  join jobs j on e.job_id = j.job_id
  join departments d on e.department_id = d.department_id
 where d.department_id < 100;
 
-- Non Equi Join, als Benutzer SCOTT ausfuehren
connect scott/tiger

select e.ename, e.job, s.grade
  from emp e
  join salgrade s on e.sal between s.losal and s.hisal;
 
-- Oracle-Schreibweise
-- als Benutzer HR ausfuehren

connect hr/hr

select e.last_name, j.job_title, d.department_name
   from employees e, jobs j, departments d
  where /* JOINS */
        e.job_id = j.job_id
    and e.department_id = d.department_id
        /* CONSTRAINTS */
    and d.department_id = 20;
